package gov.va.med.mhv.health.repository;

import gov.va.med.mhv.health.model.VAAllergy;

import java.util.List;

import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface VAAllergyRepository extends JpaRepository<VAAllergy, Long>{
	
	
    @Query("select a from VAAllergy a where a.patientId = :patientid order by a.observationDate desc")
	 List<VAAllergy>  getAllergiesForPatient(@Param ("patientid") Long patientid);
    
    @Query("select a from VAAllergy a where a.patientId = :patientid order by a.observationDate desc")
	 List<VAAllergy>  getDashboardVaAllergiesForPatient(@Param ("patientid") Long patientid,Pageable page);


}
